<?php

use App\Http\Controllers\PostController;
use App\Livewire\Admin\AcceptAndSelectRoom;
use App\Livewire\Admin\AllBookings;
use App\Livewire\Admin\CheckOut;
use App\Livewire\Admin\EditStatus;
use App\Livewire\Admin\RejectedBookings;
use App\Livewire\Admin\SelectRooms;
use App\Livewire\Admin\ShowAcceptReject;
use App\Livewire\Articles\CreateArticle;
use App\Livewire\Articles\EditArticle;
use App\Livewire\Articles\ShowArticles;
use App\Livewire\Booking\AllBooking;
use App\Livewire\Booking\CreateBooking;
use App\Livewire\Booking\ViewBookings;
use App\Livewire\Canteen\CreateCanteen;
use App\Livewire\Guest\CreateGuest;
use App\Livewire\Guest\EditGuest;
use App\Livewire\Guest\ShowGuests;
use App\Livewire\Guest\ViewGuest;
use App\Livewire\Payment\GenerateBill;
use App\Livewire\Payment\GenerateCanteenBill;
use App\Livewire\Payment\UpdateBill;
use App\Livewire\Profile\CreateProfile;
use App\Livewire\Profile\UpdateProfile;
use App\Livewire\Admin\FollowUps;
use App\Livewire\Admin\DeleteBookings;
use App\Livewire\Admin\SearchRoomOccupied;
use App\Livewire\Guest\RoomRequestForm;
use App\Livewire\Guest\UploadAllocationForm;
use App\Livewire\Payment\MonthlyPaymentReport;
use App\Livewire\Payment\UpdateCanteenBill;
use App\Models\Payment;
use Illuminate\Support\Facades\Route;
use Livewire\Volt\Volt;

Route::get('/', function () {
    return view('welcome');
})->name('home');

Route::get('/about', function () {
    return view('about');
})->name('about');
Route::get('/contactus', function () {
    return view('contactus');
})->name('contactus');
Route::view('dashboard', 'dashboard')->middleware(['auth', 'verified'])->name('dashboard');

Route::view('admin_dashboard', 'admin_dashboard')->middleware(['auth', 'admin', 'verified'])
    ->name('admin_dashboard');
//Route::get('/dashboard', [UserController::class, 'index'])->name('dashboard');
//  Route::get('/admin/dashboard', [AdminController::class, 'index'])->name('admin_dashboard');

Route::middleware(['auth', 'verified', 'admin'])->group(function () {



    Route::redirect('settings', 'settings/profile');

    Volt::route('settings/profile', 'settings.profile')->name('settings.profile');
    Volt::route('settings/password', 'settings.password')->name('settings.password');
    Volt::route('settings/appearance', 'settings.appearance')->name('settings.appearance');
});
Route::get('/posts', [PostController::class, 'index'])->name('posts.index')->middleware(['auth', 'admin']);

Route::middleware(['auth', 'verified'])->group(function () {
    Route::get('/profile/create', CreateProfile::class)->name('profile.create');
    Route::get('/profile/update', UpdateProfile::class)->name('profile.update');
    Route::get('/guest/create', CreateGuest::class)->name('guest.create');
    Route::get('/guests', ShowGuests::class)->name('guest.show');
    Route::get('/guests/{id}/edit', EditGuest::class)->name('guests.edit');
    Route::get('/guests/{id}/view', ViewGuest::class)->name('guests.view');
    Route::get('/booking/create/{id}', CreateBooking::class)->name('booking.create');
    Route::get('/bookings/current', ViewBookings::class)->name('bookings.current');
    Route::get('/bookings/all', AllBooking::class)->name('bookings.all');
    Route::get('/guests/room_request_form', RoomRequestForm::class)->name('guests.room_request_form');
    Route::get('/guests/download/room_request_form_pdf/{booking_id}', RoomRequestForm::class)->name('guests.room_request_form_pdf');
    Route::get('/guests/upload/allocation_form/{booking_id}', UploadAllocationForm::class)->name('guests.allocation_form');
});

Route::middleware(['auth', 'admin', 'verified'])->group(function () {
    Route::get('/admin', ShowAcceptReject::class)->name('admin');
    Route::get('/admin/editStatus/{id}', EditStatus::class)->name('admin.editStatus');
    Route::get('/admin/acceptandbook', AcceptAndSelectRoom::class)->name('admin.acceptandbook');
    Route::get('/admin/assignrooms/{bookingId}', SelectRooms::class)->name('admin.assignrooms');

    Route::get('/admin/rejected_bookings', RejectedBookings::class)->name('admin.rejected_bookings');

    Route::get('/admin/generate_bill/{bookingId}', GenerateBill::class)->name('admin.generate_bill');
    Route::get('/admin/update_bill/{bookingId}', UpdateBill::class)->name('admin.update_bill');
    Route::get('/admin/create/canteen/{booking_id}', CreateCanteen::class)->name('admin.create.canteen');
    Route::get('/admin/generate_canteen_bill/{bookingId}', GenerateCanteenBill::class)->name('admin.generate_canteen_bill');
    Route::get('/admin/update_canteen_bill/{bookingId}', UpdateCanteenBill::class)->name('admin.update_canteen_bill');
    Route::get('/admin/checkout/{bookingId}', CheckOut::class)->name('admin.checkout');
    Route::get('/admin/followups', FollowUps::class)->name('admin.followups');
    Route::get('/admin/clear_booking', DeleteBookings::class)->name('admin.clear_booking');
    Route::get('/admin/all_booking', AllBookings::class)->name('admin.all_booking');
    Route::get('/admin/search_occupied_rooms', SearchRoomOccupied::class)->name('admin.search_occupied_rooms');
    Route::get('/admin/booking_report', MonthlyPaymentReport::class)->name('admin.booking_report');
});

Route::view('/workflow_diagram', 'workflow_diagram')->name('workflow_diagram');
Route::view('/download/room_request_form_pdf', 'room_request_form')->name('download.room_request_form');

Route::get('/check-time', function () {
    return [
        'server_time' => date('Y-m-d H:i:s'),
        'laravel_time' => now()->toDateTimeString(),
    ];
});


require __DIR__ . '/auth.php';
