@include('frontend_partials.head')

<!-- Background Content, ensure it doesn't block clicks -->
<div class="h-full w-full border-neutral-200 dark:border-neutral-700 z-10 pointer-events-none mt-10">
    <x-placeholder-pattern class="absolute inset-0 size-full stroke-gray-900/20 dark:stroke-neutral-100/20" />
    <!-- Here -->
    <div class="text-4xl text-center "><span class="[text-shadow:_0_8px_8px_rgb(99_102_241_/_0.6)] text-gray-700">Motilal
            Nehru National Institute of Technology Allahabad, Prayagraj (MNNIT)</span></div>
    <div
        class="flex items-center justify-center w-full transition-opacity opacity-100 duration-750 lg:grow starting:opacity-0 mt-10">
        <main class="flex max-w-[700px] w-full flex-col-reverse lg:max-w-5xl lg:flex-row">
            <div
                class="text-[16px] leading-[20px] flex-1 p-6 pb-12 lg:py-8 lg:px-8 bg-white dark:bg-[#161615] dark:text-[#EDEDEC] shadow-[inset_0px_0px_0px_1px_rgba(26,26,0,0.16)] dark:shadow-[inset_0px_0px_0px_1px_#fffaed2d] rounded-bl-lg rounded-br-lg lg:rounded-tl-lg lg:rounded-br-none text-center">
                <h1 class="mb-1 font-medium text-2xl text-yellow-800"><u>Executive Development Center</u></h1>
                <img src="images/mnnit_logo.png" class="w-1/2 border border-blue-900 p-2 rounded-lg mx-auto">



                @if (Route::has('login'))
                    @auth
                        <a href="{{ url('/dashboard') }}"
                            class="inline-block hover:bg-black hover:border-black px-5 py-1.5 transition duration-500 ease-in-out bg-[#1b1b18] rounded-sm border border-black text-yellow-500 text-sm leading-normal mt-5 transform hover:-translate-y-1 hover:scale-110 z-50 pointer-events-auto">
                            Dashboard
                        </a>
                    @else
                        <a href="{{ route('login') }}"
                            class="inline-block hover:bg-black hover:border-black px-5 py-1.5 transition duration-500 ease-in-out bg-[#1b1b18] rounded-sm border border-black text-yellow-500 text-sm leading-normal mt-5 transform hover:-translate-y-1
                  z-50 pointer-events-auto me-2">
                            Login Here
                        </a>

                        @if (Route::has('register'))
                            <a href="{{ route('register') }}"
                                class="inline-block hover:bg-black hover:border-black px-5 py-1.5 transition duration-500 ease-in-out bg-[#1b1b18] rounded-sm border border-black text-yellow-500 text-sm leading-normal mt-5 transform hover:-translate-y-1  z-50 pointer-events-auto ml-2">
                                Register
                            </a>
                        @endif
                    @endauth
                @endif

            </div>
            <div
                class="bg-[#fff2f2] dark:bg-[#1D0002] relative lg:-ml-px -mb-px lg:mb-0 rounded-t-lg lg:rounded-t-none lg:rounded-r-lg aspect-[335/376] lg:aspect-auto w-full lg:w-[580px] shrink-0 overflow-hidden">


                <div
                    class="absolute inset-0 rounded-t-lg lg:rounded-t-none lg:rounded-r-lg shadow-[inset_0px_0px_0px_1px_rgba(26,26,0,0.16)] dark:shadow-[inset_0px_0px_0px_1px_#fffaed2d]">
                    <div class="has-floating-animation h-full w-full">
                        <img id="floating-image" src="/images/edc_pic2.jpg"
                            class="is-floating-animated border w-full rounded-xl bg-cover h-full shadow-lg">

                    </div>


                </div>
            </div>
        </main>
    </div>
    <!-- End Here -->
    <div class="mt-20 text-center text-gray-600"> Copyright © EDC, MNNIT Allahabad. All rights reserved. </div>
</div>

<!-- Add JavaScript for toggle functionality -->
<script>
    // Wait for the DOM to fully load
    document.addEventListener('DOMContentLoaded', function() {
        const mobileMenuButton = document.getElementById('mobile-menu-button');
        const mobileMenu = document.getElementById('mobile-menu');

        // Toggle mobile menu visibility when the button is clicked
        mobileMenuButton.addEventListener('click', () => {
            mobileMenu.classList.toggle('hidden');
            // Add transition effects for the mobile menu
            if (!mobileMenu.classList.contains('hidden')) {
                mobileMenu.classList.remove('opacity-0', 'translate-y-4');
                mobileMenu.classList.add('opacity-100', 'translate-y-0');
            } else {
                mobileMenu.classList.remove('opacity-100', 'translate-y-0');
                mobileMenu.classList.add('opacity-0', 'translate-y-4');
            }
        });
    });


    // Get the image element
    const image = document.getElementById('floating-image');

    // Add the floating animation class immediately when the page loads
    window.addEventListener('load', function() {
        image.classList.add('floating');
    });
</script>

</body>

</html>
